<?php

declare(strict_types=1);

namespace Drupal\Tests\system\Kernel\Scripts;

use Drupal\Core\Command\DbImportCommand;
use Drupal\Core\Database\Database;
use Drupal\KernelTests\KernelTestBase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RequiresPhpExtension;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;
use Symfony\Component\Console\Tester\CommandTester;

/**
 * Test that the DbImportCommand works correctly.
 */
#[Group('console')]
#[RunTestsInSeparateProcesses]
class DbImportCommandTest extends KernelTestBase {

  /**
   * Tables that should be part of the exported script.
   *
   * @var array
   */
  protected $tables = [
    'block_content',
    'block_content_field_data',
    'block_content_field_revision',
    'block_content_revision',
    'cachetags',
    'config',
    'cache_discovery',
    'cache_bootstrap',
    'file_managed',
    'key_value_expire',
    'menu_link_content',
    'menu_link_content_data',
    'path_alias',
    'sessions',
    'user__roles',
    'users',
    'users_field_data',
    'watchdog',
  ];

  /**
   * Tests the command directly.
   */
  #[RequiresPhpExtension('pdo_sqlite')]
  public function testDbImportCommand(): void {
    $connection_info = [
      'driver' => 'sqlite',
      'database' => ':memory:',
    ];
    Database::addConnectionInfo($this->databasePrefix, 'default', $connection_info);

    $command = new DbImportCommand();
    $command_tester = new CommandTester($command);
    $command_tester->execute([
      'script' => __DIR__ . '/../../../fixtures/update/drupal-10.3.0.bare.standard.php.gz',
      '--database' => $this->databasePrefix,
    ]);

    // The tables should now exist.
    $connection = Database::getConnection('default', $this->databasePrefix);
    foreach ($this->tables as $table) {
      $this->assertTrue($connection
        ->schema()
        ->tableExists($table), strtr('Table @table created by the database script.', ['@table' => $table]));
    }
  }

}
